% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_classes_and_methods.R
\docType{class}
\name{easyPubMed-class}
\alias{easyPubMed-class}
\alias{initialize,easyPubMed-method}
\title{Class easyPubMed.}
\usage{
\S4method{initialize}{easyPubMed}(.Object, query_string, job_info)
}
\arguments{
\item{.Object}{The easyPubMed object being built.}

\item{query_string}{String (character vector of length 1) corresponding 
to the user-provided text of the query to be submitted to PubMed.}

\item{job_info}{List, this should be the output of `EPM_job_split()`.}
}
\description{
Class easyPubMed defines objects that represent PubMed Query jobs and
the corresponding results. Briefly, these objects are initialized using
information that will guide the communication with the NCBI Entrez server. 
Also, easyPubMed objects are used to store raw and processed data retrieved 
from Pubmed.
}
\section{Slots}{

\describe{
\item{\code{query}}{String (character vector of length 1) corresponding to 
the PubMed request submitted by the user.}

\item{\code{meta}}{List including meta information about the PubMed Query job.}

\item{\code{uilist}}{List including all unique identifiers corresponding to 
the Pubmed records returned by the query. Can be empty.}

\item{\code{raw}}{List including the raw data (in `xml` or `medline` format) 
retrieved from the NCBI eFetch server. Can be empty.}

\item{\code{data}}{Data.frame including processed data based on 
the xml raw data retrieved from PubMed.}

\item{\code{misc}}{List including additional information.}
}}

\author{
Damiano Fantini \email{damiano.fantini@gmail.com}
}
