% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_validate_fetch_params}
\alias{EPM_validate_fetch_params}
\title{Validate Parameters of a PubMed Retrieval Job.}
\usage{
EPM_validate_fetch_params(params)
}
\arguments{
\item{params}{list of user-provided parameters.}
}
\value{
list including the vetted parameters.
}
\description{
Check and correct (if needed) the parameters of an easyPubMed
retrieval job.
}
\details{
The following elements are expected and/or parsed from the
`params` list:
\itemize{
\item `encoding`. String, e.g. "UTF-8".
\item `format`. String, must be one of the
following values: `c('uilist', 'medline', 'xml')`.
\item `store_contents`. Logical, shall retrieved contents 
be stored in the object. If `FALSE`, the `write_to_file`
argument must be `TRUE`.
\item `write_to_file` Logical, shall retrieved contents
be written to a file (or list of files). If `FALSE`, the
`store_contents` argument must be `TRUE`.
\item `outfile_path`. String, path to the folder where 
files will be written. This argument is evaluated only
if `write_to_file` is `TRUE`.
\item `outfile_prefix`. String, prefix of the 
files that will be written locally. This argument 
is evaluated only
if `write_to_file` is `TRUE`.
\item `api_key`. String, NCBI API key. Can be NULL.
\item `max_records_per_batch`. Integer scalar (numeric 
vector of length 1), this is the maximum number of 
records retrieved per batch. It deafualts to 10,000.
\item `verbose`. Logical, shall details about the 
progress of the operation be printed to console.
}
}
\examples{
prms <- list(
  encoding  = 'UTF-8', 
  format = 'xml', 
  api_key = NULL,
  store_contents = TRUE, 
  write_to_file = FALSE, 
  verbose = TRUE)
easyPubMed:::EPM_validate_fetch_params(prms)




}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
