% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_esearch_efetch_seq}
\alias{EPM_esearch_efetch_seq}
\title{Retrieve Results via an Esearch and Efetch sequence.}
\usage{
EPM_esearch_efetch_seq(
  query_string,
  api_key = NULL,
  batch_size = 500,
  encoding = "UTF-8",
  format = "xml",
  max_restart_attempts = 10
)
}
\arguments{
\item{query_string}{String (character vector of length 1), 
corresponding to the query URL to the remote server.}

\item{api_key}{String (character vector of length 1), 
corresponding to the NCBI API key. Can be NULL.}

\item{batch_size}{Integer, max number of records to be retrieved 
as a batch. This corresponds to the "retmax" NCBI parameter.}

\item{encoding}{String (character vector of length 1), encoding
of the resulting records (e.g., "UTF-8").}

\item{format}{String (character vector of length 1),
desired format of the Pubmed records. This must be one of the values in
c("xml", "medline", "uilist").}

\item{max_restart_attempts}{Integer, max number of attempts in case of a
failed iteration.}
}
\value{
Character vector including the response from the server.
}
\description{
Submit a Query to the NCBI ESearch Server, 
capture the response and retrieve the corresponding PubMed records from 
the NCBI EFetch Server. 
Up to the first n=10,000 records returned by the query 
will be retrieved (as per the NCBI policy). This does not include
a timeout limit to complete the operation.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  qry <- 'Damiano Fantini[AU] AND "2018"[PDAT]'
  easyPubMed:::EPM_esearch_efetch_seq(query_string = qry, format = "uilist")
}, silent = TRUE)
setTimeLimit(elapsed = Inf)


}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
