% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_grouping.R
\name{add_grouping}
\alias{add_grouping}
\alias{is_wrapper_with_grouping}
\alias{get_grouping}
\title{Add a cell grouping to a dataset}
\usage{
add_grouping(dataset, grouping, group_ids = NULL, ...)

is_wrapper_with_grouping(dataset)

get_grouping(dataset, grouping = NULL)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{grouping}{A grouping of the cells, can be a named vector or a dataframe with \emph{group_id} and \emph{cell_id}}

\item{group_ids}{All group identifiers, optional}

\item{...}{Extra information to be stored in the dataset}
}
\value{
A dynwrap object with the grouping added.
}
\description{
Add a cell grouping to a dataset
}
\examples{
dataset <- example_dataset

grouping <- sample(c("A", "B", "C"), length(dataset$cell_ids), replace = TRUE)
names(grouping) <- dataset$cell_ids

dataset <- add_grouping(dataset, grouping)
head(dataset$grouping)

}
\keyword{adapt_trajectory}
