% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrGetDerivs.R
\name{dynr.trajectory}
\alias{dynr.trajectory}
\title{A Function to perform numerical integration of the chosen ODE system, 
for a user-specified set of initial conditions. Plots the resulting solution(s) 
in the phase plane. This function from the phaseR package written by 
Michael J. Grayling.}
\usage{
dynr.trajectory(deriv, y0 = NULL, n = NULL, tlim, tstep = 0.01,
  parameters = NULL, system = "two.dim", col = "black", add = TRUE,
  state.names = c("x", "y"), ...)
}
\arguments{
\item{deriv}{A function computing the derivative at a point for the specified 
ODE system. See the phaseR package guide for more examples.}

\item{y0}{The initial condition(s) (ICs). In one-dimensional system, this can 
either be a single number indicating a single IC or a vector indicating multiple 
ICs. In two-dimensional system, this can either be a vector of length two 
reflecting the location of the two dependent variables initially, 
or it can be matrix where each row reflects a different set of ICs. 
Alternatively this can be left blank and the user can use locator to specify initial condition(s) on a plot. In this case, for one dimensional systems, all initial conditions are taken at tlim[1], even if not selected so on the graph. Defaults to NULL.}

\item{n}{If y0 is left NULL so initial conditions can be specified using 
locator, n sets the number of initial conditions to be chosen. Defaults to NULL.}

\item{tlim}{Sets the limits of the independent variable for which the solution 
should be plotted. Should be a vector of length two. If tlim[2] > tlim[1], 
then tstep should be negative to indicate a backwards trajectory.}

\item{tstep}{The step length of the independent variable, used 
in numerical integration. Defaults to 0.01.}

\item{parameters}{Parameters of the ODE system, to be passed to deriv. 
Supplied as a vector; the order of the parameters can be found from the deriv file. 
Defaults to NULL.}

\item{system}{Set to either "one.dim" or "two.dim" to indicate the type of 
system being analysed. Defaults to "two.dim".}

\item{col}{The color(s) to plot the trajectories in. Will be reset accordingly if it is a vector not of the length of the number of initial conditions. Defaults to "black".}

\item{add}{Logical.  Defaults to TRUE.
TRUE = the trajectories added to an existing plot; FALSE = a new plot is created.}

\item{state.names}{State names for the ODE functions that do not use positional states}

\item{...}{Additional arguments to be passed to either plot or arrows.}
}
\value{
Returns a list with the following components:
add, col, deriv, n, parameters, system, tlim, tstep, t, x, y, ylab, y0. 
Most of these components correspond simply to their original input values. 

The only new elements are:
t = A vector containing the values of the independent variable at each integration step.

x	= In the two dimensional system case, a matrix whose columns are the 
numerically computed values of the first dependent variable for each set of ICs.

y	= In the two dimensional system case, a matrix whose columns are the numerically computed values of the second dependent variable for each initial condition. In the one dimensional system case, a matrix whose columns are the numerically computed values of the dependent variable for each initial condition.

y0	= As per input, but converted to a matrix if supplied as a vector initially.
}
\description{
A Function to perform numerical integration of the chosen ODE system, 
for a user-specified set of initial conditions. Plots the resulting solution(s) 
in the phase plane. This function from the phaseR package written by 
Michael J. Grayling.
}
\note{
The phaseR package was taken off cran as off 10/1/2019 so we are 
exporting some selected functions from phaseR_2.0 published on 8/20/2018.
For details of these functions please see original documentations on the
phaseR package.
}
\references{
Grayling, Michael J. (2014). phaseR: An R Package for Phase Plane Analysis of Autonomous
ODE Systems. The R Journal, 6(2), 43-51. DOI: 10.32614/RJ-2014-023. Available at
https://doi.org/10.32614/RJ-2014-023
}

