% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_glm.R
\name{clean_glm}
\alias{clean_glm}
\title{Create a Clean Summary Table from a glm Object}
\usage{
clean_glm(fit, columns = NULL, expand_factors = TRUE,
  variable_labels = NULL, prep_kable = FALSE, decimals = 2,
  formatp_list = NULL)
}
\arguments{
\item{fit}{Object returned from \code{\link[stats]{glm}}.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"beta"}, \code{"se"}, \code{"betaci"},
\code{"beta_se"}, \code{"beta_ci"} \code{"or"}, \code{"orci"}, \code{"or_ci"},
\code{"hr"}, \code{"hrci"}, \code{"hr_ci")}, \code{"z"}, \code{"t"}, and
\code{"p"}.}

\item{expand_factors}{Logical value for whether to include two blank rows for
factor variables (name of variable and reference group).}

\item{variable_labels}{Character vector in case you want labels other than
the variable names.}

\item{prep_kable}{Logical value for whether to prepare for
printing via \code{\link[knitr]{kable}}. Right now, it just adds forward
slashes so factor levels are indented, which only applies if there are factor
variables and \code{expand_factors = TRUE}.}

\item{decimals}{Numeric value of vector specifying number of decimal places for
each column.}

\item{formatp_list}{Arguments to pass to \code{\link[tab]{formatp}}.}
}
\value{
Data frame.
}
\description{
Formats a \code{\link[stats]{glm}} object for printing to console or
inputting to \code{\link[knitr]{kable}}.
}
\examples{
fit <- glm(mpg ~ wt + as.factor(cyl) + hp, data = mtcars)
clean_glm(fit)
fit \%>\% clean_glm(prep_kable = TRUE) \%>\% knitr::kable()

}
