% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckduck-answer.R
\name{duckduck_answer}
\alias{duckduck_answer}
\title{Call DuckDuckGo Instant Answer API}
\usage{
duckduck_answer(query, no_redirect = FALSE, no_html = FALSE,
  skip_disambig = FALSE, app_name = "duckduckr")
}
\arguments{
\item{query}{the query string}

\item{no_redirect}{TRUE to skip HTTP redirects (for !bang commands)}

\item{no_html}{TRUE to remove html from results}

\item{skip_disambig}{TRUE to to skip disambiguation (D) Type.}

\item{app_name}{the appname used to identify your application.}
}
\value{
Always returns a list. If the API call was successful it contains the response of
        the duckduckgo API as parsed by \code{\link[jsonlite]{fromJSON}}. In addition the object's
        attributes contain additional meta data. Especially the \code{status} attribute indicates
        if something went wrong during the HTTP call or parsing of the JSON text.

        In case the call was successful the \code{status} attribute is equal to "OK".

        In case something went wrong, the \code{status} attribute is equal to "error" and in the
        \code{error} attribute you will find more information. In particular the \code{type}, which is
        either "http_error" or "json_parse_error" depending on the error's source.

        In case of a "http_error", there is an additional \code{message} and \code{http_status}
        element.

        In case of "json_parse_error", there is an additional \code{message} element.

        In addition there is always a \code{source} element with the URL used to query the data.
}
\description{
Makes a synchronous API call to the DuckDuckGo Instant Answer API.
Take a look at DuckDuckGo's terms of use (\url{https://api.duckduckgo.com/api}) before using it.
}
\examples{
\dontrun{
tmp <- duckduck_answer("duckduckgo")
tmp$Abstract
}
}
\seealso{
\url{https://api.duckduckgo.com/api} for more information on the API and their terms of use.
}
