% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_data}
\alias{plot_data}
\title{Obtain the data used in the graphs}
\usage{
plot_data(x, dim1 = 1, dim2 = 2, type = c("Asy1", "Asy2", "Sub", "Ite"), ...)
}
\arguments{
\item{x}{A Dual Scale object}

\item{dim1}{Component for the horizontal axis. Default dimension 1}

\item{dim2}{Component for the vertical axis. Default dimension 2}

\item{type}{Graph type
\describe{
\item{Asy1}{Assymetric graph for projected options versus normed subjects
(default)}
\item{Asy2}{Assymetric graph for normed options versus projected subjects}
\item{Sub}{Only subjects graph}
\item{Ite}{Only items graph}
}}

\item{...}{Arguments to be passed to methods}
}
\value{
A dataframe with the data used
}
\description{
Obtain the data used in the graphs
}
\examples{
plot_data(ds_cf(curricula))
plot_data(ds_mc(singaporean))
plot_data(ds_mcf(singaporean, crit = 1))
plot_data(ds_pc(christmas))
plot_data(ds_ro(goverment))
}
