% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{applied_crm_sim}
\alias{applied_crm_sim}
\title{Simulate CRM trials using specified design options}
\usage{
applied_crm_sim(true_tox, prior, target, max_sample_size, first_dose,
    num_sims, cohort_size = 1, dose_func = applied_crm, ...)
}
\arguments{
\item{true_tox}{A vector of 'true' underlying rates of toxicity for each of
the dose levels.}

\item{prior}{A vector of prior estimates of toxicity probabilties for the
dose levels.}

\item{target}{The target DLT rate.}

\item{max_sample_size}{The maximum number of subjects to be recruited in any
simulation.}

\item{first_dose}{The first dose level to tested.}

\item{num_sims}{The total number of simulations to be run.}

\item{cohort_size}{The size of the cohorts. Default is 1.}

\item{dose_func}{The function to be employed in executing the CRM. Default is
applied_crm.}

\item{...}{Any other arguements detailed in dtpcrm::applied_crm.}
}
\value{
A list containing two further lists. The first of these lists contains
    the operating charateristics of the design, the second contains the
    underlying data for each of the simulation iterations.
}
\description{
applied_crm_sim is used to simulate trials using the continual
    reassessment method with specified design options to determine the
    operating characteristics.
}
\examples{
# It may take quite long for large num_sims
prior  <- c(0.1, 0.3, 0.5)
target <- 0.2
true_tox <- c(0.15, 0.25, 0.45)
first_dose <- 1
num_sims <- 5  # recommend doing 5000 simulations for the final design

applied_crm_sim(true_tox, prior, target, max_sample_size = 30, first_dose,
                num_sims, cohort_size = 1, dose_func = applied_crm)

}
\references{
O'Quigley, J. O., Pepe, M., and Fisher, L. (1990). Continual
    reassessment method: A practical design for phase I clinical trials in
    cancer. Biometrics 46:33-48.

Cheung, Y. K. (2011). Dose Finding by the Continual Reassessment Method. New
York: Chapman & Hall/CRC Press.
}
\keyword{CRM}
\keyword{Simulations}
\keyword{dtpcrm}
