% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_fullfit.R
\name{dtms_fullfit}
\alias{dtms_fullfit}
\title{Estimate unconstrained discrete-time multistate model}
\usage{
dtms_fullfit(
  data,
  controls = NULL,
  formula = NULL,
  weights = NULL,
  fromvar = "from",
  tovar = "to",
  reference = 1,
  package = "VGAM",
  ...
)
}
\arguments{
\item{data}{Data frame in transition format, as created with \code{dtms_format}.}

\item{controls}{Character (optional), names of control variables}

\item{formula}{Formula (optional). If no formula is specified, it will be build from the information specified with controls, fromvar, tovar, and timevar.}

\item{weights}{Character (optional), name of variable in `data` with survey weights.}

\item{fromvar}{Character (optional), name of variable in `data` with starting state. Default is "from".}

\item{tovar}{Character (optional), name of variable in `data` with receiving state. Default is "to".}

\item{reference}{Numeric or character (optional). Reference level of multinomial logistic regression.}

\item{package}{Character, chooses package for multinomial logistic regression, currently `VGAM`, `nnet`, and `mclogit` are supported. Default is `VGAM`.}

\item{...}{Further arguments passed to estimation functions.}
}
\value{
Returns an object with class depending on the package used.
}
\description{
This function estimates an unconstrained discrete-time multistate model
using multinomial logistic regression. This is achieved by interacting
the starting state with all predictors in the model. It is a wrapper for
\code{dtms_fit()} with `full=TRUE` and otherwise slightly less arguments.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
## Fit model
fit <- dtms_fullfit(data=estdata)
}
