% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string-cleaning.R
\name{audit_clean}
\alias{audit_clean}
\title{Audit String Cleaning Operation}
\usage{
audit_clean(x, clean_fn, name = NULL)
}
\arguments{
\item{x}{Character vector to clean.}

\item{clean_fn}{A function that takes a character vector and returns a
cleaned character vector of the same length.}

\item{name}{Optional name for the variable (used in output). If NULL,
attempts to capture the variable name from the call.}
}
\value{
An S3 object of class \code{audit_clean} containing:
\describe{
\item{name}{Name of the variable}
\item{clean_fn_name}{Name of the cleaning function used}
\item{n_total}{Total number of elements}
\item{n_changed}{Count of values that changed}
\item{n_unchanged}{Count of values that stayed the same}
\item{n_na}{Count of NA values (unchanged by definition)}
\item{pct_changed}{Percentage of non-NA values that changed}
\item{change_examples}{data.table with sample before/after pairs}
\item{cleaned}{The cleaned character vector}
}
}
\description{
Applies a cleaning function to a character vector and reports what changed.
Provides transparency about the cleaning operation by showing counts and
before/after examples.
}
\examples{
library(data.table)
firms <- c("Apple Inc.", "MICROSOFT CORP", "Alphabet LLC", NA)
result <- audit_clean(firms, clean_firm_name)
result$cleaned

}
\seealso{
\code{\link[=diagnose_strings]{diagnose_strings()}} for string quality diagnostics,
\code{\link[=clean_var_names]{clean_var_names()}} and \code{\link[=clean_firm_name]{clean_firm_name()}} for built-in cleaning functions
}
