% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expmodel.r
\name{plot.expmodel}
\alias{plot.expmodel}
\title{Plot a histogram and estimated densities/distributions of Exponential-based
model  object}
\usage{
\method{plot}{expmodel}(
  x,
  cum = FALSE,
  nmax = 4,
  graphs = NULL,
  bins = 40,
  hist = TRUE,
  linesize = 1,
  ...
)
}
\arguments{
\item{x}{\code{expmodel} object.}

\item{cum}{A logical scalar, whether or not it plots cumulative
histogram/distributions instead of plain histogram/densities.
Default value is \code{FALSE}.}

\item{nmax}{A maximum number of estimates to be plotted in the graph.
The default value is 4.}

\item{graphs}{A vector of indices to be displayed in the graph.
These indices appear in the leftmost column of the table in
\code{summary.expmodel}.
The default value is \code{NULL}, and if it is not \code{NULL}, only the estimated
densities designated by \code{graphs} option appear, and \code{nmax} is ignored.}

\item{bins}{A number of bins of the histogram.}

\item{hist}{A logical scalar. If \code{TRUE}, display a histogram, otherwise not.
The default value is \code{TRUE}.}

\item{linesize}{A positive numeric scalar, which indicates the thickness of
lines. The default value is \code{1}.}

\item{...}{Arguments to be passed to or from other methods.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plot the histogram and, if available, estimated densities
or cumulative distributions of \code{expmodel} object.
}
\examples{
## Create `expmodel` object from a data set mixexpgamma$n200
emodel <- expmodel(mixexpgamma$n200)
## Plot it (histogram only)
plot(emodel)
}
\seealso{
\code{\link[=expmodel]{expmodel()}} \code{\link[=summary.expmodel]{summary.expmodel()}} \code{\link[=func.expmodel]{func.expmodel()}} \code{\link[=pdf_expmodel]{pdf_expmodel()}}
\code{\link[=cdf_expmodel]{cdf_expmodel()}}
}
