% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussmodel.r
\name{cdf_gaussmodel}
\alias{cdf_gaussmodel}
\title{Cumulative distribution function of Gaussian-based model}
\usage{
cdf_gaussmodel(coeff, mu, sig, x)
}
\arguments{
\item{coeff}{A coefficient vector in increasing order of degrees;
the first element is 0th degree, ..., and last element is the largest degree
of coefficients.}

\item{mu}{A mean of Gaussian distribution.}

\item{sig}{A standard deviation of Gaussian distribution, which is positive.}

\item{x}{A numeric input vector.}
}
\value{
A numeric vector of CDF of Gaussian-based model.
}
\description{
A cumulative distribution function(CDF) of Gaussian-based model.
To access parameters and coefficients in an object \code{gmodel}
of a class \code{gaussmodel}, use \code{gmodel$result[k, "mu1"]},
\code{gmodel$result[k, "sig1"]}, \code{gmodel$coeffs[[k]]} for some index \code{k}.
This index appears in the leftmost column of estimation table generated by
\code{summary(gmodel)}.
}
\examples{
## Create an object of `gaussmodel`
gmodel <- gaussmodel(mix2gauss$n200)
## Estimate with a degree 6, a mean 0, and standard deviations 0.5
gmodel <- estimate(gmodel, 6, 0, 0.5)
## Input vector
x <- seq(-3, 3, 0.1)
## Output of PDF in above estimation
yv <- cdf_gaussmodel(gmodel$coeffs[[1]], gmodel$result[1, "mu1"],
 gmodel$result[1, "sig1"], x)
}
\seealso{
\code{\link[=gaussmodel]{gaussmodel()}} \code{\link[=summary.gaussmodel]{summary.gaussmodel()}} \code{\link[=estimate.gaussmodel]{estimate.gaussmodel()}}
\code{\link[=func.gaussmodel]{func.gaussmodel()}} \code{\link[=pdf_gaussmodel]{pdf_gaussmodel()}}
}
