% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_weekly.R
\name{to_weekly}
\alias{to_weekly}
\title{Change a daily to a weekly differenced time series}
\usage{
to_weekly(x, incl_forecast = T, forecast_length = 365, diff = T, dayofweek = 5)
}
\arguments{
\item{x}{input series}

\item{incl_forecast}{whether the series contains a forecast that shall be omitted}

\item{forecast_length}{length of forecast}

\item{diff}{should series be differenced}

\item{dayofweek}{which day of the week (friday=5)}
}
\description{
This function computes the weekly aggregates or differences (by default Friday to Friday) for any daily time series in the xts format.
}
\examples{
to_weekly(xts::xts(rnorm(365, 10,1), seq.Date(as.Date("2010-01-01"), length.out=365, by="days")))
}
\author{
Daniel Ollech
}
