% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_drglm.R
\name{big.drglm}
\alias{big.drglm}
\title{Fitting Linear and Generalized Linear Models to out of the memory data sets in "Divide and Recombine" approach}
\usage{
big.drglm(data.generator, formula, chunks, family)
}
\arguments{
\item{data.generator}{Using the function \code{\link{make.data}} to initialize the data reading function with the data set path and chunk size, then the data.generate is used directly as data source for the \code{\link{big.drglm}} function.}

\item{formula}{An entity belonging to the "formula" class (or one that can be transformed into that class) represents a symbolic representation of the model that needs to be adjusted. Specifics about how the model is defined can be found in the 'Details' section.}

\item{chunks}{Number of subsets to be divided.}

\item{family}{An explanation of the error distribution that will be implemented in the model.}
}
\value{
A Generalized Linear Model is fitted in "Divide & Recombine" approach using preferred number of chunks to data set. A list of model coefficients is estimated using divide and recombine method with the respective standard error of estimates.
}
\description{
Function \code{big.drglm} aimed to fit GLMs to datasets larger in size that can not be  stored in memory. It uses popular divide and recombine technique to handle large data sets efficiently.
}
\examples{
# Create a toy dataset
set.seed(123)
# Number of rows to be generated
n <- 10000

# Creating dataset
dataset <- data.frame(
  Var_1 = round(rnorm(n, mean = 50, sd = 10)),
  Var_2 = round(rnorm(n, mean = 7.5, sd = 2.1)),
  Var_3 = as.factor(sample(c("0", "1"), n, replace = TRUE)),
  Var_4 = as.factor(sample(c("0", "1", "2"), n, replace = TRUE)),
  Var_5 = as.factor(sample(0:15, n, replace = TRUE)),
  Var_6 = round(rnorm(n, mean = 60, sd = 5))
)

# Save the dataset to a temporary file
temp_file <- tempfile(fileext = ".csv")
write.csv(dataset, file = temp_file, row.names = FALSE)

# Path to the temporary file
dataset_path <- temp_file
dataset_path  # Display the path to the temporary file

# Initialize the data reading function with the data set path and chunk size
da <- drglm::make.data(dataset_path, chunksize = 1000)
# Fitting MLR Models
nmodel <- drglm::big.drglm(da,
formula = Var_1 ~ Var_2+ factor(Var_3)+factor(Var_4)+ factor(Var_5)+ Var_6,
10, family="gaussian")
# View the results table
print(nmodel)
# Fitting logistic Regression Model
bmodel <- drglm::big.drglm(da,
formula = factor(Var_3) ~ Var_1+ Var_2+ factor(Var_4)+ factor(Var_5)+ Var_6,
10, family="binomial")
# View the results table
print(bmodel)
# Fitting Poisson Regression Model
pmodel <- drglm::big.drglm(da,
formula = Var_5 ~ Var_1+ Var_2+ factor(Var_3)+ factor(Var_4)+ Var_6,
10, family="poisson")
# View the results table
print(pmodel)
}
\references{
\itemize{
\item Xi, R., Lin, N., & Chen, Y. (2009). Compression and aggregation for logistic regression analysis in data cubes. IEEE Transactions on Knowledge and Data Engineering, 21(4).
\item Chen, Y., Dong, G., Han, J., Pei, J., Wah, B. W., & Wang, J. (2006). Regression cubes with losseless compression and aggregation. IEEE Transactions on Knowledge and Data Engineering, 18(12).
\item Zuo, W., & Li, Y. (2018). A New Stochastic Restricted Liu Estimator for the Logistic Regression Model. Open Journal of Statistics, 08(01).
\item Karim, M. R., & Islam, M. A. (2019). Reliability and Survival Analysis. In Reliability and Survival Analysis.
\item Enea, M. (2009) Fitting Linear Models and Generalized Linear Models with large data sets in R.
\item Bates, D. (2009) Technical Report on Least Square Calculations.
\item Lumley, T. (2009) \emph{biglm} package documentation.
}
}
\seealso{
\code{\link{drglm}}, \code{\link{drglm.multinom}}
}
\author{
MH Nayem
}
