% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_medx.R
\name{pr_medx}
\alias{pr_medx}
\title{Probability of minimum X\% effective dose}
\usage{
pr_medx(
  x,
  doses = attr(x, "doses"),
  ed,
  greater = TRUE,
  small_bound = 0,
  time = NULL
)
}
\arguments{
\item{x}{output from a call to \code{dreamer_mcmc()}.}

\item{doses}{the doses for which pr(minimum effective X\% dose) is to be
calculated.}

\item{ed}{a number between 0 and 100 indicating the ed\% dose that is
being sought.}

\item{greater}{if \code{TRUE}, higher responses indicate better efficacy.  If
\code{FALSE}, lower responses indicate better efficacy.`}

\item{small_bound}{the lower (upper) bound of the response variable
when \code{greater = TRUE} (\code{FALSE}).  This is used to calculate the
\code{ed}\% effect as \code{ed / 100 * (effect_100 - small_bound) + small_bound}.}

\item{time}{the time (scalar) at which the Pr(MEDX) should be calculated.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{dose}: numeric dose levels.
\item \code{prob}: Prob(EDX | data) for each dose. Note: these probabilities do
not necessarily sum to 1 because the EDX may not exist. In fact,
Pr(EDX does not exist | data) = \code{1 - sum(prob)}.
}
}
\description{
Calculate the probability a dose being the smallest dose
that has at least X\% of the maximum efficacy.
}
\details{
Obtaining the probability of a particular does being the
minimum efficacious dose achieving \code{ed}\% efficacy is dependent on
the doses specified.

For a given MCMC sample of parameters, the 100\% efficacy value is defined
as the highest efficacy of the doses specified.  For each posterior draw
of MCMC parameters, the minimum \code{ed}\% efficacious dose is defined as the
lowest dose what has at least \code{ed}\% efficacy relative to the 100\%
efficacy value.

The \code{ed}\% effect is calculated as
\code{ed / 100 * (effect_100 - small_bound) + small_bound} where \code{effect_100}
is the largest mean response among \code{doses} for a given MCMC iteration.
}
\examples{
set.seed(888)
data <- dreamer_data_linear(
  n_cohorts = c(20, 20, 20),
  dose = c(0, 3, 10),
  b1 = 1,
  b2 = .1,
  sigma = 5
)

# Bayesian model averaging
output <- dreamer_mcmc(
 data = data,
 n_adapt = 1e3,
 n_burn = 1e3,
 n_iter = 1e3,
 n_chains = 2,
 silent = FALSE,
 mod_linear = model_linear(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 ),
 mod_quad = model_quad(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   mu_b3 = 0,
   sigma_b3 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 )
)

pr_medx(output, ed = 80)

# single model
pr_medx(output$mod_linear, ed = 80)
}
