% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onemode_EffectiveSize_deprecatedV100.R
\name{computeBurtsES}
\alias{computeBurtsES}
\title{Compute Burt's (1992) Effective Size for Ego Networks from a Sociomatrix}
\usage{
computeBurtsES(
  net,
  inParallel = FALSE,
  nCores = NULL,
  isolates = NA,
  pendants = 1
)
}
\arguments{
\item{net}{The one-mode sociomatrix with network ties.}

\item{inParallel}{TRUE/FALSE. TRUE indicates that parallel processing will be used to compute the statistic with the \emph{foreach} package. FALSE indicates that parallel processing will not be used. Set to FALSE by default.}

\item{nCores}{If inParallel = TRUE, the number of computing cores for parallel processing. If this value is not specified, then the function internally provides it by dividing the number of available cores in half.}

\item{isolates}{The numerical value that represents what value will isolates be given. Set to NA by default.}

\item{pendants}{The numerical value that represents what value will pendant vertices be given. Set to 1 by default. Pendant vertices are those nodes who have one outgoing tie.}
}
\value{
The vector of ego network effective size values.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{computeBurtsES()} has been deprecated starting on version 1.0.0 of the \code{dream} package. Please use the \code{netstats_om_effective()} function and see the \code{NEWS.md} file for more details.

This function computes Burt's (1992) one-mode ego effective size based upon a sociomatrix (see details).
}
\details{
The formula for Burt's (1992; see also Borgatti 1997) one-mode ego effective size is:
\deqn{ E_{i} = \sum_{j} 1 - \sum_{q}p_{iq}m_{jq} ; q \neq i \neq j}
where \eqn{E_{i}} is the ego effective size for an ego \emph{i}.
\eqn{p_{iq}} is formulated as:
\deqn{\frac{(z_{iq} + z_{qi}) }{\sum_{j}(z_{ij} + z_{ji})} ;  i \neq j}
and \eqn{m_{jq}} is:
\deqn{m_{jq} = \frac{(z_{jq} + z_{qj})}{max(z_{jk} + z_{kj})}}

While this function internally locates isolates (i.e., nodes
who have no ties) and pendants (i.e., nodes who only have
one tie), the user should specify what values for constraint are returned for them via the \emph{isolates} and
\emph{pendants} options. Pendant vertices are those nodes who have one outgoing tie.
}
\examples{
# For this example, we recreate the ego network provided in Borgatti (1997):
BorgattiEgoNet <- matrix(
 c(0,1,0,0,0,0,0,0,1,
   1,0,0,0,0,0,0,0,1,
   0,0,0,1,0,0,0,0,1,
   0,0,1,0,0,0,0,0,1,
   0,0,0,0,0,1,0,0,1,
  0,0,0,0,1,0,0,0,1,
  0,0,0,0,0,0,0,1,1,
   0,0,0,0,0,0,1,0,1,
   1,1,1,1,1,1,1,1,0),
 nrow = 9, ncol = 9, byrow = TRUE)
colnames(BorgattiEgoNet) <- rownames(BorgattiEgoNet) <- c("A", "B", "C",
                                                         "D", "E", "F",
                                                        "G", "H", "ego")
#the effective size value for the ego replicates that provided in Borgatti (1997)
computeBurtsES(BorgattiEgoNet)

# For this example, we recreate the ego network provided in Burt (1992: 56):
BurtEgoNet <- matrix(c(
  0,1,0,0,1,1,1,
 1,0,0,1,0,0,1,
 0,0,0,0,0,0,1,
 0,1,0,0,0,0,1,
 1,0,0,0,0,0,1,
 1,0,0,0,0,0,1,
 1,1,1,1,1,1,0),
 nrow = 7, ncol = 7)
colnames(BurtEgoNet) <- rownames(BurtEgoNet) <- c("A", "B", "C", "D", "E",
                                                 "F", "ego")
#the effective size value for the ego replicates that provided in Burt (1992: 56)
computeBurtsES(BurtEgoNet)
}
\references{
Burt, Ronald. 1992. \emph{Structural Holes: The Social Structure of Competition}.
Harvard University Press.

Borgatti, Stephen. 1997. "Structural Holes: Unpacking Burt's Redundancy Measures." \emph{Connections} 20(1): 35-38.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
