% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npaths.R
\name{computeNPaths}
\alias{computeNPaths}
\title{Compute the Number of Paths of Length K in a One-Mode Network}
\usage{
computeNPaths(net, k)
}
\arguments{
\item{net}{An unweighted one-mode network adjacency matrix.}

\item{k}{A numerical value that corresponds to the length of the paths to be computed.}
}
\value{
An \emph{n} x \emph{n} matrix of counts of paths.
}
\description{
This function calculates the number of paths of length \emph{k}
between any two vertices in an unweighted one-mode network.
}
\details{
A nice result from graph theory is that the number of paths of length \emph{k} between
vertices \emph{i} and \emph{j} can be found by:
\deqn{ A_{ij}^k }

This function is similar to the functions provided in \emph{igraph} that provide the path between
two vertices. The main difference is that this function provides the counts
of paths between all vertices in the network. In addition, this function assumes that
there are no self-loops (i.e., the diagonal of the matrix is 0).
}
\examples{

# For this example, we generate a random one-mode graph with the sna package.
#creating the random network with 10 actors
set.seed(9999)
rnet <- matrix(sample(c(0,1), 10*10, replace = TRUE, prob = c(0.8,0.2)),
               nrow = 10, ncol = 10, byrow = TRUE)
diag(rnet) <- 0 #setting self ties to 0
#counting the paths of length 2
computeNPaths(rnet, k = 2)
#counting the paths of length 5
computeNPaths(rnet, k = 5)
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
