% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twomode_homophilous4Cycles.R
\name{computeHomFourCycles}
\alias{computeHomFourCycles}
\title{Compute Fujimoto, Snijders, and Valente's (2018) Homophilous Four-Cycles for Two-Mode Networks}
\usage{
computeHomFourCycles(net, mem)
}
\arguments{
\item{net}{The two-mode adjacency matrix.}

\item{mem}{The vector of membership values that the homophilous four-cycles will be based on.}
}
\value{
The vector of counts of homophilous four-cycles for the two-mode network.
}
\description{
This function computes the number of homophilous four-cycles in
a two-mode network as proposed by Fujimoto, Snijders, and Valente (2018: 380).
See Fujimoto, Snijders, and Valente (2018) for more details about this
measure.
}
\details{
Following Fujimoto, Snijders, and Valente (2018: 380), the number
of homophilous four-cycles for actor \emph{i} is:
\deqn{ \sum_{j} \sum_{a\neq b} y_{ia}y_{ib}y_{ja}y_{jb}I{{v_{i} = v_{j}}}}
where \emph{y} is the two-mode adjacency matrix, \emph{v} is the vector of
membership scores (e.g., sports/club membership), \emph{a} and \emph{b} represent
the level two groups, and \eqn{I{v_i = v_j}} is the indicator function that
is 1 if the values are the same and 0 if not.
}
\examples{

# For this example, we use the Davis Southern Women's Dataset.
data("southern.women")
#creating a random binary membership vector
set.seed(9999)
membership <- sample(0:1, nrow(southern.women), replace = TRUE)
#the homophilous four-cycle values
computeHomFourCycles(southern.women, mem = membership)
}
\references{
Fujimoto, Kayo, Tom A.B. Snijders, and Thomas W. Valente. 2018. "Multivariate
dynamics of one-mode and two-mode networks: Explaining similarity in sports
participation among friends." \emph{Network Science} 6(3): 370-395.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
