% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{dixon_stat}
\alias{dixon_stat}
\title{Dixon test statistic to identify dragon kings (DKs)}
\usage{
dixon_stat(vals, r)
}
\arguments{
\item{vals}{numeric vector with at least 3 elements}

\item{r}{integer indicating number of DKs in \code{vals}}
}
\value{
Dixon test statistic
}
\description{
\code{dixon_stat} calculates the DIxon test statistic to determine whether
there is significant support for the existence of \code{r} DKs in
\code{vals}. This test is less susceptible to swamping and masking, but is
also less powerful than the SS and SRS test statistics.
}
\examples{
# generate a numeric vector with DKs
temp <- c(rexp(100),   # exponentially distributed RV
          15, 15, 15)  # DK elements

# calculate test statistic for DKs
dixon_stat(temp, r = 3)
}
\references{
Wheatley S, Sornette D (2015). Multiple outlier detection in samples with exponential & pareto tails: Redeeming the inward approach & detecting dragon kings. Swiss Finance Institute Research Paper Series No. 15-28. <doi:10.2139/ssrn.2645709>

Dixon WJ (1950). Analysis of extreme values. \emph{Ann Math Stat}, \strong{21}(4): 488-506. <doi:10.1214/aoms/1177729747>

Likes J (1967). Distribution of Dixon's statistics in the case of an exponential population. \emph{Metrika}, \strong{11}(1): 46-54. <doi:10.1007/bf02613574>
}
