% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpseg.R
\name{sgtable}
\alias{sgtable}
\title{construct a segment table}
\usage{
sgtable(ends, starts, jumps = TRUE)
}
\arguments{
\item{ends}{integer vector of segment ends}

\item{starts}{integer vector of segment starts}

\item{jumps}{same parameter as passed to recursion function,
allowing for discontinous jumps (TRUE) or enforcing joint
segments (FALSE)}
}
\value{
a table with segment \code{start} and \code{end} columns
}
\description{
Constructs a segment table from segment ends (\code{imax}) returned
by \code{\link{dpseg}} backtracing functions
\code{\link{backtrace_r}} and \code{backtrace_c}. Correct segment
break-points require to know whether segment recursion was run with
the \code{jumps} option of \code{\link{dpseg}}. In joint segments
(\code{jumps=FALSE}) segment borders are part of both left and
right segments.
}
