\name{rmst.deepSurv}
\alias{rmst.deepSurv}
%\alias{rmstFit}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
The restricted mean survival time (RMST)
}
\description{
Calculate the restricted mean survival time (RMST) for deepSurv survival objects.
}
\usage{
\method{rmst}{deepSurv}(object, newdata = NULL, risk = NULL, tau = NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{this is a survival object created by deepSurv.}
  \item{risk}{the predicted from the deepSUrv model, i.e. risk = exp(predict(model, newdata)).}
  \item{newdata}{optional new data at which the RMST is calculated. If absent, RMST is for the dataframe used in the original model fit.}
  \item{tau}{the upper bound of the restricted mean survival time calculation.}
  \item{\dots}{additional arguments to be passed to the functions such as rmst.coxph, rmst.lple, rmst.Surv etc.}
}
\value{A value or vector of the restricted mean survival time is returned.}
\details{
  The restricted mean survival time (RMST) is the mean of the truncated survival time at some finite value tau.
  The RMST is defined as,

    RMST(tau) = E(min(T, tau)) = int_0 ^tau S(t)dt,

  where S(t) = P(T>t) is the survival function of the random variable T.
}
\author{Bingshu E. Chen}
\seealso{
  \code{\link[lpl]{rmst}},
  \code{\link[lpl]{rmst.coxph}},
  \code{\link[survival]{coxph}},
  \code{\link[survival]{Surv}}
}
%\references{}
\examples{
  set.seed(29)
  n     = 5
  time  = rexp(n, 1)
  event = rbinom(n, 1, 0.75)
  x     = rnorm(n)
  y     = Surv(time, event)

  ### calculate the restricted mean survival time at tau = 0.5
  rms   = rmst(y, tau = 0.5)

  ### calculate the RMST for deepSurv
  #fit   = deepSurv(y~x, model = model)
  #RMST  = rmst(fit, risk = c(1, 2, 3), tau = 2)
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Restricted Mean Survival Time }
\keyword{ Survival Analysis }
