% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.divfor.R
\name{predict.divfor}
\alias{predict.divfor}
\title{Diversity Forest prediction}
\usage{
\method{predict}{divfor}(
  object,
  data = NULL,
  predict.all = FALSE,
  num.trees = object$num.trees,
  type = "response",
  se.method = "infjack",
  quantiles = c(0.1, 0.5, 0.9),
  seed = NULL,
  num.threads = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{\code{divfor} object.}

\item{data}{New test data of class \code{data.frame} or \code{gwaa.data} (GenABEL).}

\item{predict.all}{Return individual predictions for each tree instead of aggregated predictions for all trees. Return a matrix (sample x tree) for classification and regression, a 3d array for probability estimation (sample x class x tree) and survival (sample x time x tree).}

\item{num.trees}{Number of trees used for prediction. The first \code{num.trees} in the forest are used.}

\item{type}{Type of prediction. One of 'response', 'se', 'terminalNodes', 'quantiles' with default 'response'. See below for details.}

\item{se.method}{Method to compute standard errors. One of 'jack', 'infjack' with default 'infjack'. Only applicable if type = 'se'. See below for details.}

\item{quantiles}{Vector of quantiles for quantile prediction. Set \code{type = 'quantiles'} to use.}

\item{seed}{Random seed. Default is \code{NULL}, which generates the seed from \code{R}. Set to \code{0} to ignore the \code{R} seed. The seed is used in case of ties in classification mode.}

\item{num.threads}{Number of threads. Default is number of CPUs available.}

\item{verbose}{Verbose output on or off.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Object of class \code{divfor.prediction} with elements
  \tabular{ll}{
      \code{predictions}    \tab Predicted classes/values (only for classification and regression)  \cr
      \code{unique.death.times} \tab Unique death times (only for survival). \cr
      \code{chf} \tab Estimated cumulative hazard function for each sample (only for survival). \cr
      \code{survival} \tab Estimated survival function for each sample (only for survival). \cr
      \code{num.trees}   \tab Number of trees. \cr
      \code{num.independent.variables} \tab Number of independent variables. \cr
      \code{treetype}    \tab Type of forest/tree. Classification, regression or survival. \cr
      \code{num.samples}     \tab Number of samples.
  }
}
\description{
Prediction with new data and a saved forest from \code{\link{divfor}}.
}
\details{
This package is a fork of the R package 'ranger' that implements random forests using an
efficient C++ implementation. More precisely, 'diversityForest' was written by modifying
the code of 'ranger', version 0.11.0. Therefore, details on further functionalities
of the code that are not presented in the help pages of 'diversityForest' are found
in the help pages of 'ranger' (version 0.11.0). The code in the example sections of \code{\link{divfor}} and \code{\link{tunedivfor}} can be
used as a template for all common application scenarios with respect to classification,
regression and survival prediction using univariable, binary splitting. Some function 
arguments adopted from the 'ranger' package may not be useable with diversity forests
(for the current package version).
}
\references{
\itemize{
  \item Hornung, R. (2022). Diversity forests: Using split sampling to enable innovative complex split procedures in random forests. SN Computer Science 3(2):1, <\doi{10.1007/s42979-021-00920-1}>.
  \item Wright, M. N., Ziegler, A. (2017). ranger: A fast Implementation of Random Forests for High Dimensional Data in C++ and R. Journal of Statistical Software 77:1-17, <\doi{10.18637/jss.v077.i01}>.
  \item Wager, S., Hastie T., & Efron, B. (2014). Confidence Intervals for Random Forests: The Jackknife and the Infinitesimal Jackknife. Journal of Machine Learning Research 15:1625-1651.
  \item Meinshausen (2006). Quantile Regression Forests. Journal of Machine Learning Research 7:983-999.
  }
}
\seealso{
\code{\link{divfor}}
}
\author{
Marvin N. Wright
}
