% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull.R
\name{weibull_plt}
\alias{weibull_plt}
\title{Weibull coefficients of power-law transformed Weibull}
\usage{
weibull_plt(scale = 1, shape = 2, a = 1, b = 1, inv = FALSE)
}
\arguments{
\item{shape, scale}{shape and scale of the distribution with default values of 2 and 1 respectively.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}

 ## Comparing probabilites of power-law transformed transformed variables
 pweibull(3,shape=2,scale=1)
 coeff = weibull_plt(shape=2,scale=1,a=5,b=7)$coefficients
 pweibull(5*3^7,shape=coeff[["shape"]],scale=coeff[["scale"]])

 pweibull(5*0.8^7,shape=2,scale=1)
 coeff = weibull_plt(shape=2,scale=1,a=5,b=7,inv=TRUE)$coefficients
 pweibull(0.8,shape=coeff[["shape"]],scale=coeff[["scale"]])

 ## Comparing the first moments and sample means of power-law transformed variables for large enough samples
 x = rweibull(1e5,shape=2,scale=1)
 coeff = weibull_plt(shape=2,scale=1,a=2,b=0.5)$coefficients
 y = rweibull(1e5,shape=coeff[["shape"]],scale=coeff[["scale"]])
 mean(2*x^0.5)
 mean(y)
 mweibull(r=1,shape=coeff[["shape"]],scale=coeff[["scale"]],lower.tail=FALSE)
}
\description{
Coefficients of a power-law transformed Weibull distribution
}
\details{
If the random variable y is Weibull distributed with mean meanlog and standard deviation sdlog, then the power-law transformed variable

 \deqn{ y = ax^b }

 is Weibull distributed with scale \eqn{ ( \frac{scale}{a})^{\frac{1}{b}} } and shape \eqn{b*shape}.
}
