% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llr_vuong.R
\name{llr_vuong}
\alias{llr_vuong}
\title{Vuong's closeness test}
\usage{
llr_vuong(x, y, np.x, np.y, corr = c("none", "BIC", "AIC"))
}
\arguments{
\item{x, y}{vector of log-likelihoods}

\item{np.x, np.y}{Number of paremeters respectively}

\item{corr}{type of correction for parameters, defaults to none.}
}
\value{
returns data frame with test statistic, p-value and character vector indicating the test outcome.
}
\description{
Likelihood ratio test for model selection using the Kullback-Leibler information criterion \insertCite{vuong1989likelihood}{distributionsrd}
}
\examples{

x <- rlnorm(1e4, meanlog = -0.5, sdlog = 0.5)
pareto_fit <- combdist.mle(x = x, dist = "pareto")
pareto_loglike <- dcombdist(x = x, dist = "pareto", coeff = pareto_fit$coefficients, log = TRUE)
lnorm_fit <- combdist.mle(x = x, dist = "lnorm")
lnorm_loglike <- dcombdist(x = x, dist = "lnorm", coeff = lnorm_fit$coefficients, log = TRUE)

llr_vuong(x = pareto_loglike, y = lnorm_loglike, np.x = pareto_fit$np, np.y = lnorm_fit$np)

# BIC type parameter correction
llr_vuong(x = pareto_loglike, y = lnorm_loglike, np.x = pareto_fit$np, np.y = lnorm_fit$np,
corr = "BIC")

# AIC type parameter correction
llr_vuong(x = pareto_loglike, y = lnorm_loglike, np.x = pareto_fit$np, np.y = lnorm_fit$np,
corr = "AIC")
}
\references{
\insertAllCited{}
}
