% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{composite.mle}
\alias{composite.mle}
\title{Composite MLE}
\usage{
composite.mle(x, dist, start, lower = NULL, upper = NULL)
}
\arguments{
\item{x}{data vector}

\item{dist}{character vector denoting the distribution of the first-, second- (and third) component respectively. If only two components are provided, the distribution reduces to the two-component distribution.}

\item{start}{named numeric vector holding the coefficients of the first-, second- (and third) component, predeced by coeff1., coeff2. (and  coeff3.), respectively. Coefficients for the last component do not have to be provided for the two-component distribution and will be disregarded.}

\item{lower, upper}{Lower and upper bounds to the estimated coefficients, defaults to -Inf and Inf respectively.}
}
\value{
Returns a named list containing a
\describe{
\item{coefficients}{Named vector of coefficients}
\item{convergence}{logical indicator of convergence}
\item{cutoffs}{Cutoffs of the composite distribution}
\item{n}{Length of the fitted data vector}
\item{np}{Nr. of coefficients}
\item{components}{Nr. of components}
}
}
\description{
Maximum likelihood estimation of the parameters of the two-/three- composite distribution
}
\examples{

dist <- c("invpareto", "lnorm", "pareto")
coeff <- c(
  coeff1.k = 1.5, coeff2.meanlog = -0.5,
  coeff2.sdlog = 0.5, coeff3.k = 1.5
)
lower <- c(1e-10, -Inf, 1e-10, 1e-10)
upper <- c(Inf, Inf, Inf, Inf)
x <- rcomposite(1e3, dist = dist, coeff = coeff)
\donttest{
composite.mle(x = x, dist = dist, start = coeff + 0.2, lower = lower, upper = upper)
}
#'
}
