% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{step_interp_factory}
\alias{step_interp_factory}
\title{A factory that returns a function that performs linear interpolation,
allowing for "steps" or discontinuities.}
\usage{
step_interp_factory(x, y, cont_dir = c("right", "left"), increasing = TRUE)
}
\arguments{
\item{x}{numeric vector with the "horizontal axis" coordinates of the points
to interpolate.}

\item{y}{numeric vector with the "vertical axis" coordinates of the points
to interpolate.}

\item{cont_dir}{at steps or discontinuities, the direction from which the
function is continuous. This will be "right" for a CDF or "left" for a QF.}

\item{increasing}{boolean indicating whether the function is increasing or
decreasing. Only used in the degenerate case where there is only one unique
value of \code{x}.}
}
\value{
a function with argument \code{x} that performs linear approximation of
the input data points.
}
\description{
A factory that returns a function that performs linear interpolation,
allowing for "steps" or discontinuities.
}
