% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide.nodes.R
\name{slide.nodes}
\alias{slide.nodes}
\title{Stretching a tree}
\usage{
slide.nodes(nodes, tree, slide, allow.negative.root = FALSE)
}
\arguments{
\item{nodes}{A list of the ID nodes to slide (\code{"integer"}) or names (\code{"character"}). The first node is \code{ape::Ntip(tree) + 1}, etc.}

\item{tree}{a \code{"phylo"} object.}

\item{slide}{the sliding value.}

\item{allow.negative.root}{logical, whether to allow negative branch lengths and moving the root node (\code{TRUE}) or not (\code{FALSE}; default).}
}
\value{
A \code{"phylo"} object.
}
\description{
Stretches a phylogenetic tree at a particular node
}
\details{
The sliding works by subtracting the slide value to the branch leading to the node and adding it to the descendant branches.
Note that the slide value can be negative to slide nodes the other way (up); the only requirement is that the slide does not lead to negative branch length values.
}
\examples{
set.seed(42)
## Generating a coalescent tree
tree <- rcoal(5)

## Stretching node 8 up and down
tree_slide_up <- slide.nodes(8, tree, slide = 0.075)
tree_slide_down <- slide.nodes(8, tree, slide = -0.075)

## Display the results
par(mfrow = c(3,1))
plot(tree) ; axisPhylo() ; nodelabels()
plot(tree_slide_up) ; axisPhylo() ; nodelabels()
plot(tree_slide_down) ; axisPhylo() ; nodelabels()

## Stretching many nodes
set.seed(42)
tree <- rtree(50)
move_nodes <- c(99, 93, 53, 86, 58, 63, 60, 84)
tree_slided <- slide.nodes(move_nodes, tree, slide = 0.07)

## Display the results
par(mfrow = c(2, 1))
node_colors <- c("lightblue", "orange")[((1:Nnode(tree))+Ntip(tree)) \%in\% move_nodes + 1]
plot(tree, show.tip.label = FALSE) ; axisPhylo()
nodelabels(bg = node_colors, cex = 0.5)
plot(tree_slided, show.tip.label = FALSE) ; axisPhylo()
nodelabels(bg = node_colors, cex = 0.5)

}
\seealso{
\code{\link{remove.zero.brlen}}
}
\author{
Thomas Guillerme
}
