% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{zombie_rehab}
\alias{zombie_rehab}
\title{Zombie rehab}
\format{
A tibble with 190 rows and 6 variables.
}
\source{
\href{https://www.discovr.rocks/csv/zombie_rehab.csv}{www.discovr.rocks/csv/zombie_rehab.csv}
}
\usage{
zombie_rehab
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
In the story within Field (2016) a lot of people get turned into zombies. At the end of the book
it is revealed that one of the central characters, Alice, uses a gene therapy that she invented to restore the zombies back to a human state.
This dataset relates to her first attempt at an efficacious gene therapy. It contains data from
190 zombies treated at 10 different clinics. Zombies were randomly assigned to two arms of the trial (wait list vs. gene therapy) and the outcome was
how much they resembled their pre-zombie state (as a percentage).
\itemize{
\item \strong{p_id}: The zombie's id.
\item \strong{clinic_id}: id for the clinic attended anonymised as Clinic 1 to Clinic 10.
\item \strong{intervention}: a factor that codes to which arm of the trial the participant was randomized (wait list or gene therapy).
\item \strong{resemblance}: How closely their face resembled their pre-zombified state (100\\% = the participants face is exactly like their original face, 0\\% the person bears no resemblance to their pre-zombified face).
\item \strong{zombification}: whether the initial zombification was achieved through low- or high-intensity zombification.
\item \strong{months_as_zombie}: the time (in months) that the person had spend in a zombified state before starting the intervention.
}
}
\references{
\itemize{
\item Field, A. P. (2016). \emph{An adventure in statistics: the reality enigma}. London: Sage. \url{https://www.statisticsadventure.com}
}
}
\keyword{datasets}
