\name{disag1}
\alias{disag1}
\title{
Create a disaggregated time series
}
\description{
Input an annual, quarterly series.  Create a quarterly or monthly series via ARIMA
}
\usage{
disag1(x, m)
}
\arguments{
  \item{x}{
Input ts, must have frequency of 1 or 4
}
  \item{m}{
Order of disaggregation, must be 12, 4, or 3
}
}
\details{
Uses ARIMA model on the aggregate series to create a disaggregate series
}
\value{
  \item{y_s}{Disag. series to be summed}
  \item{y_m}{Disag. series mean}
  \item{disphi}{Disagg phi value}
  \item{distheta}{Disagg theta value}
  \item{dissig2}{Disagg sigma2}
}
\references{
 William W.S. Wei and Daniel Stram, 1990, Disaggregation of
    Time Series Models, Journal of the Royal Statistics Society, B,
    Vol 52, Number 3, pp. 453-467.
 Erin M. Hodgess and William W.S. Wei, 1996, Temporal Disaggregation of
    Time Series, Applied Statistical Science I, pp. 33-43, Nova
    Science Publishers, Commack, NY
}



\keyword{ts }

