% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dipw.R
\name{dipw.ate}
\alias{dipw.ate}
\title{Estimate the Average treatment effect E[Y(1) - Y(0)] from observational data}
\usage{
dipw.ate(
  X,
  Y,
  W,
  r1 = NULL,
  r0 = NULL,
  kappa = 0.5,
  splitting = c("1", "3", "random"),
  B = 1,
  ...
)
}
\arguments{
\item{X}{the n by p input covariance matrix}

\item{Y}{the n dimensional observed response}

\item{W}{the n dimensional binary vector indicating treatment assignment}

\item{r1}{optional n dimensional vector of an initial estimate of E[Y(1) |
X_i] for i = 1, ..., n. The default is NULL}

\item{r0}{optional n dimensional vector of an initial estimate of E[Y(0) |
X_i] for i = 1, ..., n. The default is NULL}

\item{kappa}{the weight parameter for quadratic programming. Default is 0.5}

\item{splitting}{the options for splitting. "1" means B = 1 split, "3" means
B = 3 splits, "random" means random splits.}

\item{B}{the number of iterations for random splits, the default is 1. Only
used when splitting is set to "random".}

\item{\dots}{additional arguments that can be passed to
\code{\link[glmnet]{cv.glmnet}}}
}
\value{
tau the estimated average treatment effect
}
\description{
Estimate the Average treatment effect E[Y(1) - Y(0)] from observational data
}
\examples{
\dontrun{
# Estimating average treatment effect with a toy data
# Notice that the external optimisation software \code{MOSEK}
# must be installed separately before running the example code.
# Without \code{MOSEK}, the example code is not executable.
# For how to install \code{MOSEK}, see documentation of \code{\link[Rmosek]{Rmosek}}.
set.seed(1)
n <- 100; p <- 200
X <- scale(matrix(rnorm(n*p), n, p))
W <- rbinom(n, 1, 1 / (1 + exp(-X[, 1])))
Y <- X[,1] + W * X[,2] + rnorm(n)
# Getting an estimate of average treatment effect
(est <- dipw.ate(X, Y, W))
}
}
\references{
Wang, Y., Shah, R. D. (2020) \emph{Debiased inverse propensity
  score weighting for estimation of average treatment effects with
  high-dimensional confounders} \url{https://arxiv.org/abs/2011.08661}
}
