% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dilp_functions.R
\name{dilp_errors}
\alias{dilp_errors}
\title{Check for common errors in DiLP measurements}
\usage{
dilp_errors(specimen_data)
}
\arguments{
\item{specimen_data}{Processed specimen level leaf physiognomic data.  The
structure should match the structure of the output from \code{\link[=dilp_processing]{dilp_processing()}}}
}
\value{
A 7 by X data frame.  Each row shows a common error, and which specimens
from the input dataset are tripping it.
}
\description{
\code{dilp_errors()} will typically only be called internally by \code{\link[=dilp]{dilp()}}.
However, it can be used on its own to evaluate errors that commonly occur
during the data collection and processing steps.  A \code{dilp_errors()} call
will nearly always follow a \code{\link[=dilp_processing]{dilp_processing()}} call.  Returns a data frame.
}
\examples{
# Check for errors in the provided McAbeeExample dataset.
dilp_dataset <- dilp_processing(McAbeeExample)
dilp_errors <- dilp_errors(dilp_dataset)
dilp_errors
}
