% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gets.R
\name{zeit_search}
\alias{zeit_search}
\title{Search the ZEIT archive}
\source{
\url{http://developer.zeit.de/docs/}
}
\usage{
zeit_search(endpoint, query, fields, limit = 10, offset = 0, sort,
  print = TRUE)
}
\arguments{
\item{endpoint}{one of \code{author}, \code{content}, \code{department}, \code{keyword},
\code{product} or \code{series} -- provides specific search functionalities.}

\item{query}{the main search query; single string value or vector of strings.}

\item{fields}{partially select output fields, as string value or vector of strings for multiple fields.}

\item{limit}{limit the amount of matches to return; set to \code{10} by default.}

\item{offset}{offset for the list of matches; set to \code{0} by default.}

\item{sort}{sort search results by any of the returned \code{fields}.
Vector of two (\code{c([field], [direction])}), giving field and direction keyword.
Direction keywords are \code{asc} and \code{desc} for an ascending or descending
sort order respectively. Multiple sort orders are accepted as \code{list} of such vectors.}

\item{print}{if \code{TRUE} (default) the search results are printed.}
}
\value{
A list of matches to the query.
}
\description{
\code{zeit_search} exposes a search for ZEIT archive items.
You can set search queries, paginate, sort and partially select the fields,
that should be returned. Articles, that match your query, are returned with
a reduced set of meta data.
}
\details{
\emph{Endpoints}

The API is structured into several endpoints that provide specific functionalities:
\tabular{lll}{
\tab \code{author} \tab search all authors \cr
\tab \code{content} \tab search for content \cr
\tab \code{department} \tab search all departments \cr
\tab \code{keyword} \tab search all keywords \cr
\tab \code{product} \tab search all products \cr
\tab \code{series} \tab search all series
}

\emph{Query syntax}

You can search the entire article text and all meta data simply by setting the query parameter
to your search phrase. The search uses entire strings "as is". To search for multiple tokens
use a vector of strings.

All fields of an article can be queried individually by using \code{[field]:[search string]}.
For example, to get articles that have the word "Kennedy" in their headline, you would
search for \code{"title:Kennedy"}.

Currently all \code{endpoint}s other than \code{content} only support simple search phrases
with asterisk (\code{*}) wildcards.
}
\examples{
\dontrun{
# simple content search
zeit_search(endpoint="content", query="bayreuth")
zeit_search("content", "bayreuth") # same same

# multiple tokens
zeit_search("content", c("bayreuth", "festspiele"))

# entire string
zeit_search("content", "bayreuther festspiele")

# field query
zeit_search("content", "title:bayreuth")

# partial selection
zeit_search("content", "bayreuth", fields=c("title", "teaser_text"))

# pagination
zeit_search("content", "bayreuth", limit=1) # just one match
zeit_search("content", "bayreuth", limit=1, offset=1) # just the second match

# sorting
zeit_search("content", "bayreuth",
  sort=c("release_date", "asc")) # sort by date
zeit_search("content", "bayreuth",
  sort=list(c("release_date", "desc"), c("title", "asc"))) # sort by date and title

# hide matches
bt.matches <- zeit_search("content", "bayreuth", print=FALSE)

# author search
zeit_search(endpoint="author", query="Stefan Locke")
}
}

