% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.diagmeta.R
\name{as.data.frame.diagmeta}
\alias{as.data.frame.diagmeta}
\title{Extract data frame from diagmeta objects}
\usage{
\method{as.data.frame}{diagmeta}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{diagmeta}.}

\item{row.names}{Argument of R function \code{\link{as.data.frame}}
(ignored).}

\item{optional}{Argument of R function \code{\link{as.data.frame}}
(ignored).}

\item{\dots}{Other arguments.}
}
\value{
A data frame is returned by the function \code{as.data.frame}.
}
\description{
Extract data frame from objects of class \code{diagmeta}.
}
\examples{
# FENO dataset
#
data(Schneider2017)

diag1 <- diagmeta(tpos, fpos, tneg, fneg, cutpoint,
                  studlab = paste(author, year, group),
                  data = Schneider2017,
                  log.cutoff = TRUE)

as.data.frame(diag1)

}
\seealso{
\code{\link{diagmeta}} \code{\link{summary.diagmeta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
