% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_index.R
\name{pm_index}
\alias{pm_index}
\title{Multilateral Price Indexes}
\usage{
pm_index(df, p, qty, id, tm, typ = "geks", len = NULL,
lnk = NULL, bsk = "flx", wd = "flx")
}
\arguments{
\item{df}{A data frame sorted by the time period column.}

\item{p}{A string indicating the price column.}

\item{qty}{A string indicating the quantity column.}

\item{id}{A string indicating the identity column.}

\item{tm}{A string indicating the time period column. Each period must
contain two observations at least.}

\item{typ}{Relevant types of price indexes. Options include "geks"
for GEKS price indexes (by default), "ccdi" for CCDI price indexes,
"wtpd" for the weighted time product dummy method, and "gk" for the
Geary-Khamis method.}

\item{len}{Window length for linked indexes using rolling windows. A
single window is set as NULL (by default).}

\item{lnk}{Linking position in rolling windows, effective when `len`
is not NULL. If no linking position is provided, it should be set as NULL
(by default). Other options include "mean" for mean splices and numbers
for specific cases.}

\item{bsk}{The choice of baskets when items are not matched over
multiple periods. Options include "flx" (by default) for a flexible basket
that varies depending on the maximal number of matched items in
two periods each time, and "cst" for a constant basket
that takes the maximal number of matched items across all periods.}

\item{wd}{The choice of windows when items are not matched over multiple
windows. Options include "flx" (by default) for a flexible window that allows for
different items in two windows each time, and "cst" for a constant window
that takes the maximal number of matched items across all windows.}
}
\value{
A data frame consisting of the time period and price indexes.
}
\description{
Multilateral indexes refer to the case when more than two periods
are compared each time. \code{pm_index()} computes price indexes in a
multilateral approach.
}
\examples{
# Use the built-in data set "prices"
# matched items
df <- prices[[1]]
df <- df[order(df[,"t"]),]
# GEKS price indexes with a constant basket over periods
index1 <- pm_index(df, "p", "q", "id", "t", typ = "geks", bsk = "cst")
# unmatched items
df_add <- matrix(c(1, 6, 12, 5, 6, 7, 0.5, 0.5, 0.5, 9, 9, 9), nrow=3)
df_add <- as.data.frame(df_add)
colnames(df_add) <- colnames(df)
df <- rbind(df, df_add)
df <- df[order(df[,"t"]),]
# CCDI price indexes with a flexible basket over periods
index2 <- pm_index(df, "p", "q", "id", "t", typ = "ccdi", bsk = "flx")
# CCDI price indexes with rolling windows (window length at 11, linking at the first observation)
index3 <- pm_index(df, "p", "q", "id", "t", typ = "ccdi", len = 11, lnk = 1)
# CCDI price indexes with rolling windows (window length at 11, linking with mean splices)
index4 <- pm_index(df, "p", "q", "id", "t", typ = "ccdi", len = 11, lnk = "mean")
}
