% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFuncs.R
\name{checkValues}
\alias{checkValues}
\title{Checking if the value of vectors (of length 1) is authorized.}
\usage{
checkValues(listObjects, listValues)
}
\arguments{
\item{listObjects}{List of vectors, of irrespective data type and each of length 1. It contains the list of variables of which one wants to test its value against a vector of valid values. This argument is obligatory.}

\item{listValues}{List of vectors, of irrespective data type and of the same length as the 'listObjects' argument. It contains the values against which one wants to test the 'listObjects' argument. This argument is obligatory.}
}
\value{
No value is returned if all vectors correspond to the length against which it is tested. An error message is thrown when at least one of the elements of the 'listObjects' contains an invalid value, as stipulated by the 'listValues' argument.
}
\description{
Checking if the value of vectors (of length 1) is authorized.
}
\examples{
lossType <- 'absolute'
checkValues(list(lossType), list(c('absolute', 'quadratic')))
\donttest{checkValues(list(lossType), list(c('absolute', 'quadratic'), c('test', 'test2')))}

#The next error message is weird, since it does not return the real name of the listObject
#that found to be wrong.
lossType <- 'absolute55'
listObjects <- list(lossType)
listValues <- list(c('absolute', 'quadratic'))
\donttest{checkValues(listObjects, listValues)

#Now it is ok...
checkValues(list(lossType), list(c('absolute', 'quadratic')))}
}
