% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bard.bits.R
\name{bard.bits}
\alias{bard.bits}
\title{Generate unique bard bits using Shakespeare's work and DSM-5 adjectives}
\usage{
bard.bits(cat, seed = NULL)
}
\arguments{
\item{cat}{a category to be used as bard–bit. Defaults to "any", but "character",
"jobs","alliterate", "dsm_5" are available.}

\item{seed}{an optional numeric or character seed for reproducible results.}
}
\value{
\code{bard.bits()} takes a category and an optional numeric or character seed
to produce a bard–bit.
}
\description{
\code{bard.bits()} generates bard bits using Shakespeare's works and the DSM-5 to use in personal projects. The term bard–bits comes from Shakespeare's title
'The Bard of Avon' and the bits ( Shakespeare's characters, places, professions) used to come up with coherent combinations.
}
\details{
When the category is "any" (the default), the function combines Shakespeare's adjectives,
DSM-5 adjectives, colors and the characters, jobs, animals and things data frames
to then sample one adjective and one noun from each of the two combinations.

When the category is "alliterate", the function combines the adjectives and colors
data frames and the animals and characters data frame. After an adjective is selected,
the first letter will be used to match against a noun.

When the category is "character", the function will derive a bard bit from a data frame of Shakespeare's
characters and the adjectives data frame.

When the category is "jobs", the function will derive a bard bit from the adjectives and colors data frame
and sample one value from the Shakespeare's jobs data frame.

When the category is "dsm_5", the function will derive a bard bit from the combined jobs,
characters, animals and the DSM-5 adjectives data frame.
}
\examples{
bard.bits("any")
bard.bits("dsm_5", seed = 1234)
bard.bits("jobs", seed = "horrid antonio")

}
\author{
JP Monteagudo
}
