% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_functions.R
\name{HDLP}
\alias{HDLP}
\title{State Dependent High-Dimensional Local Projection}
\usage{
HDLP(
  x,
  y,
  r = NULL,
  q = NULL,
  state_variables = NULL,
  y_predetermined = FALSE,
  cumulate_y = FALSE,
  hmax = 24,
  lags = 12,
  alphas = 0.05,
  penalize_x = FALSE,
  PI_constant = NULL,
  progress_bar = TRUE,
  OLS = FALSE,
  parallel = TRUE,
  threads = NULL
)
}
\arguments{
\item{x}{\code{T_}x1 vector containing the shock variable, see \insertCite{plagborg2021local;textual}{desla} for details}

\item{y}{\code{T_}x1 vector containing the response variable, see \insertCite{plagborg2021local;textual}{desla} for details}

\item{r}{(optional) vector or matrix with \code{T_} rows, containing the "slow" variables, ones which do not react within the same period to a shock, see \insertCite{plagborg2021local;textual}{desla} for details(NULL by default)}

\item{q}{(optional) vector or matrix with \code{T_} rows, containing the "fast" variables, ones which may react within the same period to a shock, see \insertCite{plagborg2021local;textual}{desla} for details (NULL by default)}

\item{state_variables}{(optional) matrix or data frame with \code{T_} rows, containing the variables that define the states. Each column should either represent a categorical variable indicating the state of each observation, or each column should be a binary indicator for one particular state; see 'Details'.}

\item{y_predetermined}{(optional) boolean, true if the response variable \code{y} is predetermined with respect to \code{x}, i.e. cannot react within the same period to the shock. If true, the impulse response at horizon 0 is 0 (false by default)}

\item{cumulate_y}{(optional) boolean, true if the impulse response of \code{y} should be cumulated, i.e. using the cumulative sum of \code{y} as the dependent variable (false by default)}

\item{hmax}{(optional) integer, the maximum horizon up to which the impulse responses are computed. Should not exceed the \code{T_}-\code{lags} (24 by default)}

\item{lags}{(optional) integer, the number of lags to be included in the local projection model. Should not exceed \code{T_}-\code{hmax}(12 by default)}

\item{alphas}{(optional) vector of significance levels (0.05 by default)}

\item{penalize_x}{(optional) boolean, true if the parameter of interest should be penalized (\code{FALSE} by default)}

\item{PI_constant}{(optional) constant, used in the plug-in selection method (0.8 by default). For details see \insertCite{adamek2020lasso;textual}{desla}}

\item{progress_bar}{(optional) boolean, true if a progress bar should be displayed during execution (true by default)}

\item{OLS}{(optional) boolean, whether the local projections should be computed by OLS instead of the desparsified lasso. This should only be done for low-dimensional regressions (FALSE by default)}

\item{parallel}{boolean, whether parallel computing should be used. Default is TRUE.}

\item{threads}{(optional) integer, how many threads should be used for parallel computing if \code{parallel=TRUE}. Default is to use all but two.}
}
\value{
Returns a list with the following elements: \cr
\item{\code{intervals}}{list of matrices containing the point estimates and confidence intervals for the impulse response functions in each state, for significance levels given in \code{alphas}}
\item{\code{Thetahat}}{matrix (row vector) calculated from the nodewise regression at horizon 0, which is re-used at later horizons}
\item{\code{betahats}}{list of matrices (column vectors), giving the initial lasso estimate at each horizon}
}
\description{
Calculates impulse responses with local projections, using the desla function to estimate the high-dimensional linear models, and provide asymptotic inference. The naming conventions in this function follow the notation in \insertCite{plagborg2021local;textual}{desla}, in particular Equation 1 therein. This function also allows for estimating state-dependent responses, as in \insertCite{ramey2018government;textual}{desla}.
}
\details{
The input to \code{state_variables} is transformed to a suitable matrix where each column represents one state using the function \code{\link{create_state_dummies}}. See that function for further details.
}
\examples{
X<-matrix(rnorm(50*50), nrow=50)
y<-X[,1:4] \%*\% c(1, 2, 3, 4) + rnorm(50)
s<-matrix(c(rep(1,25),rep(0,50),rep(1,25)), ncol=2, dimnames = list(NULL, c("A","B")))
h<-HDLP(x=X[,4], y=y, q=X[,-4], state_variables=s, hmax=5, lags=1)
plot(h)
}
\references{
\insertAllCited{}
}
