% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_accept.R
\name{accept_leftmost_improvement}
\alias{accept_leftmost_improvement}
\title{Alternative acceptance function for multi-dimensional scores in which order (left to right, e.g. first to last) denotes relevance.}
\usage{
accept_leftmost_improvement(current_score, best_score, ..., tolerance = 0)
}
\arguments{
\item{current_score}{One- or multi-dimensional score from the current optimizing iteration (double or vector of doubles)}

\item{best_score}{Best one- or multi-dimensional score found so far (double or vector of doubles)}

\item{...}{Ignored arguments that may be used by alternative acceptance functions}

\item{tolerance}{Tolerance value: When comparing score vectors from left to right, differences within +/- tol won't immediately
shortcut the comparison at this point, allowing improvement in a less important score to exhibit some influence}
}
\value{
Boolean, TRUE if current score should be taken as the new optimal score, FALSE otherwise
}
\description{
Alternative acceptance function for multi-dimensional scores in which order (left to right, e.g. first to last) denotes relevance.
}
