% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_sidebar_components.R
\name{compSettingTag}
\alias{compSettingTag}
\alias{compSettingType}
\alias{compSettingPlot}
\alias{compSettingValue}
\alias{compSettingLabel}
\alias{compSettingID}
\alias{compSettingIcon}
\alias{compSettingColour}
\alias{compSettingBackground}
\alias{compSettingFill}
\alias{compSettingText}
\alias{compSettingTextArea}
\alias{compSettingChoices}
\alias{compSettingRange}
\alias{compSettingInline}
\alias{compSettingDownload}
\alias{compSettingWidth}
\alias{compSettingHeight}
\alias{compSettingWidthNum}
\alias{compSettingOffset}
\title{Bootstrap Component Inputs}
\usage{
compSettingTag(id, choices = NULL)

compSettingType(id, choices)

compSettingPlot(id)

compSettingValue(id)

compSettingLabel(id, label = "Label", optional = FALSE)

compSettingID(id)

compSettingIcon(id)

compSettingColour(id, status = FALSE)

compSettingBackground(id)

compSettingFill(id, label = "Fill Whole Box")

compSettingText(id, value = NULL)

compSettingTextArea(id)

compSettingChoices(id)

compSettingRange(id)

compSettingInline(id)

compSettingDownload(id)

compSettingWidth(id)

compSettingHeight(id)

compSettingWidthNum(id, value = 3L, min = 1L)

compSettingOffset(id)
}
\arguments{
\item{id}{Namespace to include the component}

\item{choices}{A vector of potential choices to include in the component}

\item{label}{Label of the input}

\item{optional}{Logical, is the input optional?}

\item{status}{Logical, are only status colours allowed, default is \code{FALSE}}

\item{value}{Value given to the component input}

\item{min}{Minimum value given to the component input}
}
\value{
A \code{shiny.tag.list} of settings specific to the selected component
}
\description{
A way to be able to adjust components so that can more easily visualise how the shiny application will look.
}
\seealso{
\code{\link{component}}
}
