% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_reads_count_primers.R
\name{remove_ns}
\alias{remove_ns}
\title{Wrapper function for core 'DADA2' filter and trim function for first filtering
step}
\usage{
remove_ns(fastq_data, multithread, temp_directory_path)
}
\arguments{
\item{fastq_data}{A \code{data.frame} containing the read file paths and the direction of the reads by sample}

\item{multithread}{(Optional). Default is FALSE.
 If TRUE, input files are filtered in parallel via \code{\link[parallel]{mclapply}}.
 If an integer is provided, it is passed to the \code{mc.cores} argument of \code{\link[parallel]{mclapply}}.
 Note that the parallelization here is by forking, and each process is loading another fastq file into
 memory. This option is ignored in Windows, as Windows does not support forking, with \code{mc.cores} set to 1.
If memory is an issue, execute in a clean environment and reduce the chunk size \code{n} and/or
 the number of threads.}

\item{temp_directory_path}{User-defined temporary directory to output unfiltered, trimmed, and filtered read directories throughout the workflow}
}
\value{
Return prefiltered reads with no Ns
}
\description{
Wrapper function for core 'DADA2' filter and trim function for first filtering
step
}
\keyword{internal}
