% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetable.R
\name{life.expectancy}
\alias{life.expectancy}
\alias{flife.expectancy}
\alias{e0}
\title{Estimate life expectancy from mortality rates}
\usage{
life.expectancy(
  data,
  series = names(data$rate)[1],
  years = data$year,
  type = c("period", "cohort"),
  age = min(data$age),
  max.age = min(100, max(data$age))
)

flife.expectancy(
  data,
  series = NULL,
  years = data$year,
  type = c("period", "cohort"),
  age,
  max.age = NULL,
  PI = FALSE,
  nsim = 500,
  ...
)

e0(
  data,
  series = NULL,
  years = data$year,
  type = c("period", "cohort"),
  max.age = NULL,
  PI = FALSE,
  nsim = 500,
  ...
)
}
\arguments{
\item{data}{Demogdata object of type \dQuote{mortality} such as obtained from \code{\link{read.demogdata}},
or an object of class \code{fmforecast} such as the output from  \code{\link{forecast.fdm}} or \code{\link{forecast.lca}},
or an object of class \code{fmforecast2} such as the output from \code{\link{forecast.fdmpr}}.}

\item{series}{Name of mortality series to use. Default is the first demogdata series in data.}

\item{years}{Vector indicating which years to use.}

\item{type}{Either \code{period} or \code{cohort}.}

\item{age}{Age at which life expectancy is to be calculated.}

\item{max.age}{Maximum age for life table calculation.}

\item{PI}{If TRUE, produce a prediction interval.}

\item{nsim}{Number of simulations to use when computing a prediction interval.}

\item{...}{Other arguments passed to \code{simulate} when producing prediction intervals.}
}
\value{
Time series of life expectancies (one per year), or a forecast object of life expectancies (one per year).
}
\description{
All three functions estimate life expectancy from \code{lifetable}.
The function \code{flife.expectancy} is primarily designed for forecast life expectancies and will optionally
produce prediction intervals. Where appropriate, it will package the results as a forecast object
which makes it much easier to product nice plots of forecast life expectancies.
The \code{e0} function is a shorthand wrapper for \code{flife.expectancy} with \code{age=0}.
}
\examples{
plot(life.expectancy(fr.mort), ylab = "Life expectancy")

france.LC <- lca(fr.mort, adjust = "e0", years = 1950:1997)
france.fcast <- forecast(france.LC, jumpchoice = "actual")
france.e0.f <- life.expectancy(france.fcast)

france.fdm <- fdm(extract.years(fr.mort, years = 1950:2006))
france.fcast <- forecast(france.fdm)
\dontrun{
e0.fcast <- e0(france.fcast, PI = TRUE, nsim = 200)
plot(e0.fcast)
}

life.expectancy(fr.mort, type = "cohort", age = 50)

}
\seealso{
\code{\link{lifetable}}
}
\author{
Rob J Hyndman
}
\keyword{models}
