% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_degrossData_print.R
\name{print.degrossData}
\alias{print.degrossData}
\title{Print a 'degrossData' object.}
\usage{
\method{print}{degrossData}(x, ...)
}
\arguments{
\item{x}{A \link{degrossData.object} generated by \link{degrossData}.}

\item{...}{Possible additional printing options for a matrix object.}
}
\value{
Print the tabulated summary statistics contained in the \link{degrossData.object} \code{x}, with additional information on the total sample size, numbers of small and big bins with their limits, the number of B-splines planned for density estimation using \code{\link{degross}}.
}
\description{
Print a summary of the information contained in a \code{\link{degrossData.object}} used by \code{\link{degross}} for density estimation from tabulated frequency and moment data.
}
\examples{
sim = simDegrossData(n=3500, plotting=TRUE)
obj.data = degrossData(Big.bins=sim$Big.bins, freq.j=sim$freq.j, m.j=sim$m.j)
print(obj.data)

}
\references{
Lambert, P. (2021) Moment-based density and risk estimation from grouped summary statistics. arXiv:2107.03883.
}
\seealso{
\code{\link{degross}}, \code{\link{degrossData}}
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
