% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_contMap.R
\name{plot_contMap}
\alias{plot_contMap}
\title{Plot continuous trait evolution on the tree}
\usage{
plot_contMap(
  contMap,
  color_scale = NULL,
  ...,
  display_plot = TRUE,
  PDF_file_path = NULL
)
}
\arguments{
\item{contMap}{List of class \code{"contMap"}, typically generated with \code{\link[=prepare_trait_data]{prepare_trait_data()}},
that contains a phylogenetic tree and associated posterior probability of being in a given state/range along branches.
Each object (i.e., \code{densityMap}) corresponds to a state/range. If no color is provided for multi-area ranges, they will be interpolated.}

\item{color_scale}{Vector of character string. List of colors to use to build the color scale with \code{\link[grDevices:colorRamp]{grDevices::colorRampPalette()}}
showing the evolution of a continuous trait. From lowest values to highest values.}

\item{...}{Additional arguments to pass down to \code{\link[phytools:contMap]{phytools::plot.contMap()}} to control plotting.}

\item{display_plot}{Logical. Whether to display the plot generated in the R console. Default is \code{TRUE}.}

\item{PDF_file_path}{Character string. If provided, the plot will be saved in a PDF file following the path provided here. The path must end with ".pdf".}
}
\value{
If \code{display_plot = TRUE}, the function plots the time-calibrated phylogeny displaying the evolution of a continuous trait.
If \code{PDF_file_path} is provided, the function exports the plot into a PDF file.

An object of class \code{"contMap"} with an (optionally) updated color scale (\verb{$cols}) is returned invisibly.
}
\description{
Plot on a time-calibrated phylogeny the evolution of a continuous trait as
summarized in a \code{contMap} object typically generated with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.

This function is a wrapper of original functions from the R package \code{{phytools}}:
\itemize{
\item Step 1: Use \code{\link[phytools:setMap]{phytools::setMap()}} to update the color scale if requested.
\item Step 2: Use \code{\link[phytools:contMap]{phytools::plot.contMap()}} to plot the mapped phylogeny.
}
}
\details{
This function is a wrapper of original functions \code{\link[phytools:setMap]{phytools::setMap()}} and \code{\link[phytools:contMap]{phytools::plot.contMap()}}. Additions are listed below:
\itemize{
\item The color scale can be controlled directly with the argument \code{color_scale}.
\item The plot can be exported in PDF using \code{PDF_file_path} to define the output file.
}
}
\examples{
# Load phylogeny
data(Ponerinae_trait_tip_data, package = "deepSTRAPP")
# Load trait df
data(Ponerinae_tree, package = "deepSTRAPP")

## Prepare trait data

\donttest{ # (May take several minutes to run)
# Extract continuous trait data as a named vector
Ponerinae_cont_tip_data <- setNames(object = Ponerinae_trait_tip_data$fake_cont_tip_data,
                                    nm = Ponerinae_trait_tip_data$Taxa)

# Get Ancestral Character Estimates based on a Brownian Motion model
# To obtain values at internal nodes
Ponerinae_ACE <- phytools::fastAnc(tree = Ponerinae_tree, x = Ponerinae_cont_tip_data)

# Infer Ancestral Character Estimates based on a Brownian Motion model
# and run a Stochastic Mapping to interpolate values along branches and obtain a "contMap" object
Ponerinae_contMap <- phytools::contMap(Ponerinae_tree, x = Ponerinae_cont_tip_data,
                                       res = 100, # Number of time steps
                                       plot = FALSE)

# Plot contMap with the phytools method
plot(x = Ponerinae_contMap, fsize = c(0.5, 1))

# Plot contMap with an updated color scale
plot_contMap(contMap = Ponerinae_contMap, fsize = c(0.5, 1),
             color_scale = c("darkgreen", "limegreen", "orange", "red"))
             # PDF_file_path = "Ponerinae_contMap.pdf") }

}
\seealso{
\code{\link[phytools:contMap]{phytools::plot.contMap()}} \code{\link[=plot_densityMaps_overlay]{plot_densityMaps_overlay()}}
}
\author{
Maël Doré

Original functions by Liam Revell in R package \code{{phytools}}. Contact: \email{liam.revell@umb.edu}
}
