% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eclairs_corMat.R
\name{eclairs_corMat}
\alias{eclairs_corMat}
\title{Estimate covariance/correlation with low rank and shrinkage}
\usage{
eclairs_corMat(C, n, k = min(n, nrow(C)), lambda = NULL)
}
\arguments{
\item{C}{sample correlation matrix between features}

\item{n}{number of samples used to estimate the sample correlation matrix}

\item{k}{the rank of the low rank component.  Defaults to min of sample size and feature number, \code{min(n, p)}.}

\item{lambda}{shrinkage parameter. If not specified, it is estimated from the data.}
}
\value{
\link{eclairs} object storing:
\describe{
 \item{U: }{orthonormal matrix with k columns representing the low rank component}
 \item{dSq: }{eigen-values so that \eqn{U diag(d^2) U^T} is the low rank component}
 \item{lambda: }{shrinkage parameter \eqn{\lambda} for the scaled diagonal component}
 \item{sigma: }{standard deviations of input columns}
 \item{nu: }{diagonal value, \eqn{\nu}, of target matrix in shrinkage}
 \item{n: }{number of samples (i.e. rows) in the original data}
 \item{p: }{number of features (i.e. columns) in the original data}
 \item{k: }{rank of low rank component}
 \item{rownames: }{sample names from the original matrix}
 \item{colnames: }{features names from the original matrix}
 \item{method: }{method used for decomposition}
 \item{call: }{the function call}
}
}
\description{
Estimate covariance/correlation with low rank and shrinkage from the correlation matrix
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)
rownames(Y) <- paste0("sample_", 1:n)
colnames(Y) <- paste0("gene_", 1:p)

# eclairs decomposition
eclairs(Y, compute = "correlation")

# eclairs decomposition from correlation matrix
eclairs_corMat(cor(Y), n = n)

}
