% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ob_decompose.R
\name{bootstrap_estimate_ob_decompose}
\alias{bootstrap_estimate_ob_decompose}
\title{Bootstrapping the OB decomposition}
\usage{
bootstrap_estimate_ob_decompose(
  formula_decomposition,
  formula_reweighting,
  data_used,
  group,
  reference_0,
  normalize_factors,
  reweighting,
  reweighting_method,
  trimming,
  trimming_threshold,
  rifreg,
  rifreg_statistic,
  rifreg_probs,
  custom_rif_function,
  na.action,
  cluster = NULL,
  ...
)
}
\arguments{
\item{formula_decomposition}{\code{formula} object that contains the formula for the decomposition}

\item{formula_reweighting}{\code{formula} object that contains the formula for
the reweighting in case of a reweighted decompostion}

\item{data_used}{\code{data.frame} with data used for estimation (including weight and group variable)}

\item{group}{name of the a binary variable (numeric or factor)
identifying the two groups that will be compared. The group identified by the
lower ranked value in `group` (i.e., 0 in the case of a dummy variable or the
first level of factor variable) is defined as group 0.}

\item{reference_0}{boolean: indicating if group 0 is the reference group and if its coefficients are used to compute the counterfactual mean.}

\item{normalize_factors}{boolean: If `TRUE`, then factor variables are normalized as proposed by Gardeazabal/Ugidos (2004)}

\item{reweighting}{boolean: if `TRUE`, then the decomposition is performed with
with respect to reweighted reference group.}

\item{reweighting_method}{specifies the method fit and predict conditional probabilities
used to derive the reweighting factor. Currently, \code{"logit"}, \code{"fastglm"},
and \code{"random_forest"} are available.}

\item{trimming}{boolean: If \code{TRUE}, observations with dominant reweighting factor
values are trimmend according to rule of Huber, Lechner, and Wunsch (2013). Per
default, trimming is set to \code{FALSE}.}

\item{trimming_threshold}{numeric: threshold defining the maximal accepted
relative weight of the reweighting factor value (i.e., inverse probability weight)
of a single observation. If \code{NULL}, the threshold is set to \eqn{sqrt(N)/N},
where \eqn{N} is the number of observations in the reference group.}

\item{rifreg}{boolean: if `TRUE`, then RIF decomposition is performed}

\item{rifreg_statistic}{string containing the distributional statistic for which to compute the RIF.}

\item{rifreg_probs}{a vector of length 1 or more with probabilities of quantiles.}

\item{custom_rif_function}{the RIF function to compute the RIF of the custom distributional statistic.}

\item{na.action}{generic function that defines how NAs in the data should be handled.}

\item{cluster}{numeric vector of same length as \code{dep_var} indicating the
clustering of observations. If \code{cluster = NULL} (default), no clustering
is a assumend and bootstrap procedure resamples individual observations. Otherwise
bootstrap procedure resamples clusters.}

\item{...}{additional parameters passed to custom_rif_function}
}
\description{
The function resamples observations and restimates the OB decomposition
with the new sample.
}
