% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-matrix.R
\name{createDistMatrix}
\alias{createDistMatrix}
\title{Create the dataframe of the Dissimilarity matrix}
\usage{
createDistMatrix(standard_matrix, output_dir = NULL, mc.cores = 1, ...)
}
\arguments{
\item{standard_matrix}{the matrix genereated by function 'createStandardMatrix'}

\item{output_dir}{the file to save the dissimilarity matrix data}

\item{mc.cores}{the number of cores would be used in parallel}

\item{...}{the same parameters which would be used in 'dtw' for calculating the distances of events}
}
\value{
the matrix, which describes pairwise distinction between M objects. It is a square symmetrical 'MxM' matrix with the (ij)th element equal to the value of a chosen measure of distinction between the (i)th and the (j)th object.
}
\description{
Use the DTW to generate the matrix
}
\examples{
\donttest{
original_data <- data.frame("1"=c(1, 2, 1), "2"=c(5,6,7), 
   "3"=c(4, 5, 8), "4"=c(3, 1, 9))
standard_matrix <- createStandardMatrix(data = original_data)
dist_matrix <- createDistMatrix(standard_matrix = standard_matrix)
}
}
