% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\docType{package}
\name{dcmodify}
\alias{dcmodify}
\alias{dcmodify-package}
\title{Data Modification By Modifying Rules}
\description{
Data often contain errors and missing data. Experts can often correct
commonly occuring errors based on simple conditional rules. This package
facilitates the expression, management, and application of such rules on data
sets.


The general workflow in \code{dcmodify} follows the following pattern.
\itemize{
  \item Define or read a set of rules with \code{\link{modifier}}.
  \item \code{\link{modify}} data with the modification rules.
  \item Examine the results either graphically or by summary.
}

There are several convenience functions that allow one to define modification
rules from the commandline, through a (freeform or yaml) file and to
investigate and maintain the rules themselves. Please have a look at the
introductory vignette

\code{vignette("introduction",package="dcmodify")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/data-cleaning/dcmodify}
  \item Report bugs at \url{https://github.com/data-cleaning/dcmodify/issues}
}

}
\author{
\strong{Maintainer}: Mark van der Loo \email{mark.vanderloo@gmail.com} (\href{https://orcid.org/0000-0002-9807-4686}{ORCID})

Authors:
\itemize{
  \item Edwin de Jonge (\href{https://orcid.org/0000-0002-6580-4718}{ORCID})
}

Other contributors:
\itemize{
  \item Sjabbo Schaveling [contributor]
  \item Floris Ruijter [contributor]
}

}
