% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_value_ts}
\alias{get_value_ts}
\title{Récupère des valeurs d'un ts}
\usage{
get_value_ts(series, date_from, date_to, n)
}
\arguments{
\item{series}{un objet ts unidimensionnel conforme aux règles de assert_ts}

\item{date_from}{un vecteur numérique, de préférence \code{integer} au format
\code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)}}

\item{date_to}{un vecteur numérique, de préférence \code{integer} au format
\code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)}}

\item{n}{un entier}
}
\value{
En sortie, la fonction retourne un vecteur (atomic) de même type que
\code{series} avec les valeurs extraites.
}
\description{
La fonction \code{get_value_ts} permet de récupérer des valeurs.
}
\details{
Il faut qu'exactement 2 arguments parmi \code{date_to}, \code{date_to} et \code{n} soient
renseignés. L'argument \code{n} combiné avec \code{date_to} ou \code{date_from} permet de
déterminer combien de période seront retourné à partir de ou jusqu'à la date
renseignée.

Il faudrait parler d'extraction car contrairement à la fonction
\code{window}, ici on retourne un vecteur devaleur et plus un objet ts.
}
\examples{

ts1 <- ts(1:100, start = 2012L, frequency = 12L)
ts2 <- ts(letters, start = 2014L, frequency = 4L)
ts3 <- ts(exp(-(1:50)), start = 2015L, frequency = 12L)

get_value_ts(series = ts1, date_from = c(2015L, 7L), date_to = c(2018L, 6L))
get_value_ts(series = ts2, date_from = c(2018L, 4L), n = 4L)
get_value_ts(series = ts3, date_to = c(2018L, 4L), n = 14L)

}
