% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasaurus-package.R
\docType{data}
\name{twelve_from_slant_long}
\alias{twelve_from_slant_long}
\title{Twelve From Slant (long) data}
\format{
A data frame with 2184 rows and 3 variables:
\itemize{
\item \strong{dataset}: the dataset the data are from
\item \strong{x}: x-values
\item \strong{y}: y-values
}
}
\usage{
twelve_from_slant_long
}
\description{
A dataset demonstrating the utility of visualization.
These 12 datasets are equal in standard measures: mean,
standard deviation, and Pearson's correlation.
}
\examples{
if (require(ggplot2)) {
  ggplot(twelve_from_slant_long, aes(x = x, y = y, colour = dataset)) +
    geom_point() +
    theme_void() +
    theme(legend.position = "none") +
    facet_wrap(~dataset, ncol = 3)
}

# Base R Plots
state = par("mfrow", "mar")

par(mfrow = c(4, 3), mar = c(3, 2, 2, 2))

sets = sort(unique(twelve_from_slant_long$dataset))

for (s in sets) {
  df = twelve_from_slant_long[twelve_from_slant_long$dataset == s, ]
  plot(df$x, df$y, pch = 16, xlab = "", ylab = "")
  title(s)
}

par(state)
}
\references{
Matejka, J., & Fitzmaurice, G. (2017).
Same Stats, Different Graphs: Generating Datasets with
Varied Appearance and Identical Statistics through Simulated
Annealing. \emph{CHI 2017 Conference proceedings: ACM SIGCHI
Conference on Human Factors in Computing Systems.}
Retrieved from \url{https://www.research.autodesk.com/publications/same-stats-different-graphs/}. #nolint
}
\keyword{datasets}
